using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Network;
using Server.Prompts;
using Server.Gumps;
using Server.Targeting;
using Server.Guilds;
using Server.Multis;
using Server.ContextMenus;



namespace Server.Items
{
	public class ContributionStatue : Item, ISecurable
	{
		private SecureLevel m_Level;

		[CommandProperty( AccessLevel.GameMaster )]
		public SecureLevel Level
		{
			get{ return m_Level; }
			set{ m_Level = value; }
		}
      
      [Constructable]
		public ContributionStatue() : base( 0x2FF6 )
		{
			Weight = 5.0;
			Name = "Miska na guildovni prispevky";
			Movable = true;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			BaseHouse house = BaseHouse.FindHouseAt( this );
			int guildLevel = Guild.GetLevel( from );

			if ( house == null || !house.IsLockedDown( this ) )
				from.SendMessage( "Miska musi byt uzamcena v dome" );
			else if ( !from.InRange( this.GetWorldLocation(), 2 ) || !from.InLOS( this ) || from.Guild == null )
				from.LocalOverheadMessage( MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that.
			if ( guildLevel < 1 )
				from.SendMessage( "Musis byt v guilde, ktera neni na maximalnim levelu" );
			else
			{
				from.SendMessage( "Zamer predmet ktery chces vhodit do misky (viz guild gump - perks)" );
				
				if ( guildLevel >= Guild.MaxLevel )
               from.SendMessage( 34, "POZOR, guilda je na maximalnim levelu. Hodnota bude prevedena na 1/10 ceny jako bankovni kredity" );
               				
				from.Target = new InternalTarget( this );
			}
		}
		
		private class InternalTarget : Target
		{
			private Item m_Statue;

			public InternalTarget( Item statue ) : base( 1, false, TargetFlags.None )
			{
				m_Statue = statue;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( from == null || from.Guild == null )
				  return;
				  
            List<Guild.RewardEntry> rw = Guild.Contribution();
            int rewardBonus = 1;
            Item item = null;
            
            foreach ( Guild.RewardEntry re in rw )
            {
               if ( target.GetType() == re.ItemType )
               {
                  rewardBonus = re.RewardValue;
                  item = (Item) target;
                  break;
               }
            }
  			
//            for ( int x = 0; x < rwrd.Count; ++x )
//            {
//               RewardEntry re = rwrd[x];
//               
//               if ( re != null )
//               {
//                  from.SendMessage( "Name: {0}, Type: {1}, Val: {2}", re.Name, re.ItemType.Name, re.RewardValue );
//               }
//            }
            
            if ( item != null )
				{
    				if( !item.IsChildOf( from.Backpack ) )
					    from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
               else if( item.BlessedFor != null && item.BlessedFor != from )
    					from.SendMessage( "Toto neni tvuj predmet" );
    				else if ( !from.InRange( m_Statue.GetWorldLocation(), 2 ) )
    				    from.SendLocalizedMessage ( 500295 ); // You are too far away to do that.
    				else
    				{
                  Guild.GiveXp( from, item.Amount * rewardBonus, false  );                  
                  Effects.PlaySound( m_Statue.Location, m_Statue.Map, Utility.RandomMinMax( 52, 53 ) );
    					item.Delete();
    					from.Target = new InternalTarget( m_Statue );
    				}
            }
				else
				{
					from.SendMessage( "Musis zamerit pozadovany predmet" );
					return;
				}		

			}
		}

		public ContributionStatue( Serial serial ) : base( serial )
		{
		}

		
		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
			base.GetContextMenuEntries( from, list );
			SetSecureLevelEntry.AddTo( from, this, list );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version
			
			writer.WriteEncodedInt( (int) m_Level );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			switch( version )
			{
				case 1:
				{
					m_Level = (SecureLevel) reader.ReadEncodedInt();
					goto case 0;
				}
            case 0:
				{
					break;
				}
			}
		}
	}
}
